#!/usr/bin/python
# vim: tabstop=4 expandtab shiftwidth=4 softtabstop=4

import httplib
from aja.controlroom.base import *
from aja.controlroom.app import *
from aja.controlroom.bin import *
from aja.controlroom.viewer import *
from aja.controlroom.capture import *
from aja.controlroom.prefs import *


class Client:

    def __init__(self, host, port):
        self.host = host
        self.port = port
        self.connection = httplib.HTTPConnection(host, port)

        self.app = App(self.connection)
        self.bin = Bin(self.connection)
        self.viewer = Viewer(self.connection)
        self.prefs = Prefs(self.connection)
        self.capture = Capture(self.connection)
