#!/usr/bin/python
# vim: tabstop=4 expandtab shiftwidth=4 softtabstop=4

from aja.controlroom.base import *
import json


class Viewer(Base):

    def __init__(self, connection):
        Base.__init__(self, connection)

    # sets
    def loadFile(self, filePath):
        cmd = "/viewer/load_file/%s" % (self.encode_path(filePath))
        self.issue_cmd(cmd)

    def playFile(self, filePath):
        cmd = "/viewer/play_file/%s" % (self.encode_path(filePath))
        self.issue_cmd(cmd)

    def play(self):
        cmd = "/viewer/play"
        self.issue_cmd(cmd)

    def stop(self):
        cmd = "/viewer/stop"
        self.issue_cmd(cmd)

    def pause(self):
        cmd = "/viewer/pause"
        self.issue_cmd(cmd)

    def gotoInPoint(self):
        cmd = "/viewer/goto_in_point"
        self.issue_cmd(cmd)

    def gotoOutPoint(self):
        cmd = "/viewer/goto_out_point"
        self.issue_cmd(cmd)

    def gotoFrame(self, frame):
        cmd = "/viewer/goto_frame/%s" % (int(frame))
        self.issue_cmd(cmd)

    def setMode(self, modeStr):
        mode = modeStr.lower()
        cmd = "/viewer/set_mode/%s" % (mode)
        self.issue_cmd(cmd)

    def setSettingsVisible(self, value):
        cmd = "/viewer/set_settings_visible/%s" % (value)
        self.issue_cmd(cmd)

    # gets
    def loadedFile(self):
        cmd = "/viewer/loaded_file"
        jsonVals = json.loads(self.issue_cmd(cmd))
        return jsonVals["value"]

    def frames(self):
        cmd = "/viewer/frames"
        jsonVals = json.loads(self.issue_cmd(cmd))
        return jsonVals["value"]

    def mode(self):
        cmd = "/viewer/mode"
        jsonVals = json.loads(self.issue_cmd(cmd))
        return jsonVals["value"]

    def settingsVisible(self):
        cmd = "/viewer/settings_visible"
        jsonVals = json.loads(self.issue_cmd(cmd))
        return jsonVals["value"]
