#!/usr/bin/python
# vim: tabstop=8 expandtab shiftwidth=4 softtabstop=4

import sys

sys.path.append("../")

from aja.controlroom.client import Client
import time

def simplePlayback(client,file):
	#setup the window to viewer only
	client.app.setPosition(300,100)
	client.app.setSize(1000,700)
	client.bin.setVisible(True)
	client.viewer.setMode("playback")
	
	#make sure file is in bin
	filesInBin = client.bin.files()
	if any(file in filePath for filePath in filesInBin) == False:
		client.bin.addFile(file)
		#wait a bit
		time.sleep(1.0)

	client.viewer.playFile(file)
        

def main():
	"""
	Used for testing
	"""
	server = 'localhost'
	port   = '8080'

	client = Client(server,port)
	simplePlayback(client,"/Users/stans/Movies/vtrx/untitled_31.mov")


if __name__ == '__main__':
	status = main()
	sys.exit(status)

