::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:::::::deltacast drivers, libraries and FWUpdater installation script::::::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

:: Specific driver name can be given in argument (example:delta-x300, delta-gwy or flex-x400)
:: if not argument is given, the script will parse the driver folder for driver files
@echo off

echo.
echo Script execution started...
echo.

cd "%~dp0"

for /f "tokens=2 delims==" %%I in ('wmic os get localdatetime /format:list') do set datetime=%%I
set START_TIME=%datetime:~0,8%-%datetime:~8,6%

set ARG1=%1

set SCRIPT_ERROR=0

echo - Check administrator rights
CALL:CHECK_ADMINISTRATOR_RIGHTS

if %ERRORLEVEL% neq 0 (
	exit /b 0
)

echo - Check folder integrity
CALL:CHECK_FOLDER_INTEGRITY

if "%SCRIPT_ERROR%"=="1" (
	exit /b 0
)

echo - Check dependencies
CALL:CHECK_DEPENDENCIES

if "%SCRIPT_ERROR%"=="1" (
	exit /b 0
)

echo - Log folder creation
CALL:CREATION_OF_LOG_FOLDER

echo - Service uninstall
CALL:SERVICE_UNINSTALL >> .\Install_Log\%START_TIME%.log 2>&1

echo - Libraries uninstall
CALL:LIBRARIES_UNINSTALL >> .\Install_Log\%START_TIME%.log 2>&1

echo - Drivers uninstall
CALL:DRIVERS_UNINSTALL >> .\Install_Log\%START_TIME%.log 2>&1

echo - Drivers install
CALL:DRIVERS_INSTALL >> .\Install_Log\%START_TIME%.log 2>&1

if "%SCRIPT_ERROR%"=="1" (
	echo DRIVERS_INSTALL ERROR : See %START_TIME%.log to find further information
	exit /b 0
)

echo - Libraries install
CALL:LIBRARIES_INSTALL >> .\Install_Log\%START_TIME%.log 2>&1

if "%SCRIPT_ERROR%"=="1" (
	echo LIBRARIES_INSTALL ERROR : See %START_TIME%.log to find further information
	exit /b 0
)

echo - Service install
CALL:SERVICE_INSTALL >> .\Install_Log\%START_TIME%.log 2>&1

if "%SCRIPT_ERROR%"=="1" (
	echo SERVICE_INSTALL ERROR : See %START_TIME%.log to find further information
	exit /b 0
)

echo - FW updater execution
CALL:FW_UPDATER

echo.
echo End of script execution

exit /b 0

::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::


::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::::::::::::::::::::::delete drivers sys files function:::::::::::::::::::::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

:MYDEL
set "FULLPATH=C:\Windows\System32\drivers\%~1"
if not exist %FULLPATH% (
	echo %YELLOW%not exist, Success : %DEFAULT%%~1
) else (
	del %FULLPATH% > NUL 2>&1
	if ERRORLEVEL 1 (
		echo %RED%/!\ Failed /!\     : %DEFAULT%%~1
	) else (
		echo %GREEN%Success            : %DEFAULT%%~1
	)
)
exit /b

::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::


::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:::::::::::::::::::::::::::Sleep function:::::::::::::::::::::::::::::::::::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

:MYSLEEP
PING 1.1.1.1 -n 1 -w 1 > NUL 2>&1
exit /b

::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:::::::::::::::::::::::::::Log time function::::::::::::::::::::::::::::::::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

:LOG_TIME
echo. 
for /f "tokens=2 delims==" %%I in ('wmic os get localdatetime /format:list') do set datetime=%%I
set datetime=%datetime:~0,8%%datetime:~8,6%
echo ---- %datetime:~0,4%/%datetime:~4,2%/%datetime:~6,2% - %datetime:~8,2%:%datetime:~10,2%:%datetime:~12,2% - %~1 ----
exit /b

::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::::::::::::::::::::::Uninstall drivers function::::::::::::::::::::::::::::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

:DRIVERS_UNINSTALL
:: Remove devices ::

echo. 
CALL:LOG_TIME "Remove devices"
echo.

if "%ARG1%"=="" (
	for %%i in (./Resources/Drivers/*.inf) do (
		echo Driver file to parse : %%i
		call :INNER_SUB %%i						
	)
) else (
	for /F "tokens=2 delims=\" %%a in ('findstr /I "PCI" "%CD%\Resources\Drivers\%ARG1%.inf"') do ( 
		echo Driver file to parse : %ARG1%.inf	
		.\Tools\devcon64.exe remove PCI\%%a
	)
)

:: Remove old package drivers ::
echo. 
CALL:LOG_TIME "Remove old package drivers"
echo.

setlocal ENABLEDELAYEDEXPANSION
set LAST_NAME=
set LAST_PROVIDER=
set SEARCH_PROVIDER="DELTACAST"
for /F "tokens=1* delims=:" %%i in ('pnputil.exe -e') do (
	if /I "%%i"=="Published name " (
		set LAST_NAME="%%j"
	)
    
	if /I "%%i"=="Driver package provider " (
		set LAST_PROVIDER="%%j"
		set PROVIDER=!LAST_PROVIDER: =!
		set NAME_TO_DELETE=!LAST_NAME: =!
		
		if /I !PROVIDER!==!SEARCH_PROVIDER! (
			echo DELETING DRIVER !NAME_TO_DELETE! PROVIDER=!PROVIDER!
			PNPUTIL.EXE -f -d !NAME_TO_DELETE!
		) 
	)
)

CALL:MYSLEEP

:: delete old drivers sys files ::
echo. 
CALL:LOG_TIME "Delete old drivers sys files"
echo.

if "%ARG1%"=="" (
	for %%i in (./Resources/Drivers/*.sys) do (
		CALL:MYDEL %%i	
	)
) else (
	CALL:MYDEL /Resources/Drivers/%ARG1%
)

CALL:MYSLEEP

:: Rescan present devices ::
echo. 
CALL:LOG_TIME "Rescan present devices :"
echo. 

.\Tools\devcon64.exe rescan

CALL:MYSLEEP

exit /b

:INNER_SUB
for /F "tokens=2 delims=\&" %%a in ('findstr /I "PCI" "%CD%\Resources\Drivers\%~1"')  do (
	.\Tools\devcon64.exe remove PCI\%%a
	exit /b
)
exit /b

::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::


::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::::::::::::::::::::::::::Libraries uninstall function::::::::::::::::::::::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

:LIBRARIES_UNINSTALL
echo. 
CALL:LOG_TIME "Delete old libraries files"
echo. 
del /Q C:\Windows\System32\VideoMasterHD* > NUL 2>&1
if exist "C:\Windows\SysWOW64\" (
	del /Q C:\Windows\SysWOW64\VideoMasterHD* > NUL 2>&1
)
exit /b

::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::


::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:::::::::::::::::::::::::::Libraries install function:::::::::::::::::::::::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

:LIBRARIES_INSTALL
echo. 
CALL:LOG_TIME "Copy libraries"
echo. 
xcopy /y .\Resources\Lib64\* "C:\Windows\System32\"
if %ERRORLEVEL% neq 0 (
	set SCRIPT_ERROR=1
	echo LIBRARIES_INSTALL ERROR : Library files not copied
	echo ERRORLEVEL is %ERRORLEVEL%
	exit /b 0
)
if exist "C:\Windows\SysWOW64\" (
	xcopy /y .\Resources\Lib32\* "C:\Windows\SysWOW64\"
)
if %ERRORLEVEL% neq 0 (
	set SCRIPT_ERROR=1
	echo LIBRARIES_INSTALL ERROR : Library files not copied
	echo ERRORLEVEL is %ERRORLEVEL%
	exit /b 0
)

exit /b

::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::


::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:::::::::::::::::::::::::::Drivers install function:::::::::::::::::::::::::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

:DRIVERS_INSTALL
echo. 
CALL:LOG_TIME "Drivers installation"
echo. 
if "%ARG1%"=="" (
	for %%i in (./Resources/Drivers/*.inf) do (
		echo Driver file to parse : %%i
		call :INNER_SUB2 %%i	
	)
) else (
	for /F "tokens=2 delims=\" %%a in ('findstr /I "PCI" "%CD%\Resources\Drivers\%ARG1%.inf"') do ( 
		echo Driver file to parse : %ARG1%.inf	
		.\Tools\devcon64.exe update "%CD%\Resources\Drivers\%ARG1%.inf" PCI\%%a
	)
)

findstr /c:"Drivers updated successfully"  .\Install_Log\%START_TIME%.log 
if %ERRORLEVEL% neq 0 (
	set SCRIPT_ERROR=1
	echo DRIVERS_INSTALL ERROR : No device found to install
	echo ERRORLEVEL is %ERRORLEVEL%
	exit /b 0
)

CALL:MYSLEEP
exit /b

:INNER_SUB2
for /F "tokens=2 delims=\&" %%a in ('findstr /I "PCI" "%CD%\Resources\Drivers\%~1"')  do (
	.\Tools\devcon64.exe update "%CD%\Resources\Drivers\%~1" PCI\%%a
	exit /b
)
exit /b

::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::


::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:::::::::::::::::::::::::::Service install function:::::::::::::::::::::::::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

:SERVICE_INSTALL
echo. 
CALL:LOG_TIME "Service installation"
echo. 
echo Copy Service files.
echo. 
mkdir "C:\Program Files\DELTACAST\VideoMaster\FWUpdater"
xcopy /y .\Resources\Bin\* "C:\Program Files\DELTACAST\VideoMaster\FWUpdater" 
if %ERRORLEVEL% neq 0 (
	set SCRIPT_ERROR=1
	echo SERVICE_INSTALL ERROR : Cannot copy binary files
	echo ERRORLEVEL is %ERRORLEVEL%
	exit /b 0
)
xcopy /y .\Tools\FWUpdater.exe "C:\Program Files\DELTACAST\VideoMaster\FWUpdater"
if %ERRORLEVEL% neq 0 (
	set SCRIPT_ERROR=1
	echo SERVICE_INSTALL ERROR : Cannot copy FWUpdater file
	echo ERRORLEVEL is %ERRORLEVEL%
	exit /b 0
)
xcopy /y .\Tools\FWUpdaterViewer.bat "%APPDATA%\Microsoft\Windows\Start Menu\Programs\Startup\"
if %ERRORLEVEL% neq 0 (
	set SCRIPT_ERROR=1
	echo SERVICE_INSTALL ERROR : Cannot copy script file
	echo ERRORLEVEL is %ERRORLEVEL%
	exit /b 0
)

"C:\Program Files\DELTACAST\VideoMaster\FWUpdater\FWUpdater.exe" -i
if %ERRORLEVEL% neq 0 (
	set SCRIPT_ERROR=1
	echo SERVICE_INSTALL ERROR : Cannot install service
	echo ERRORLEVEL is %ERRORLEVEL%
	exit /b 0
)
CALL:MYSLEEP
exit /b

::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::


::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::::::::::::::::::::::::::::Service start function::::::::::::::::::::::::::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

:FW_UPDATER
CALL:LOG_TIME "FW updater started" >> .\Install_Log\%START_TIME%.log 2>&1
echo. 
"C:\Program Files\DELTACAST\VideoMaster\FWUpdater\FWUpdater.exe" --update
if %ERRORLEVEL% neq 0 (
	if %ERRORLEVEL% neq 8 (
		set SCRIPT_ERROR=1
		echo FW_Update ERROR : Error during FW update, see FWUpdater.exe log files for further information
		CALL:LOG_TIME "FW updater stopped" >> .\Install_Log\%START_TIME%.log 2>&1
		echo ERRORLEVEL is %ERRORLEVEL%
		exit /b 0
		)
	)
)

CALL:LOG_TIME "No error detected during FW updater execution, see FWUpdater.exe log files for further information" >> .\Install_Log\%START_TIME%.log 2>&1


CALL:LOG_TIME "FW updater stopped" >> .\Install_Log\%START_TIME%.log 2>&1
exit /b

::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::


::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::::::::::::::::::::::::::Service uninstall function::::::::::::::::::::::::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

:SERVICE_UNINSTALL
echo. 
CALL:LOG_TIME "Service uninstall"
echo. 
CALL:LOG_TIME "Stop old service if any"
echo. 

if exist "C:\Program Files\DELTACAST\VideoMaster\FWUpdater" (
        if exist "C:\Windows\System32\VideoMasterhd.dll" (
	        "C:\Program Files\DELTACAST\VideoMaster\FWUpdater\FWUpdater.exe" -t
	        "C:\Program Files\DELTACAST\VideoMaster\FWUpdater\FWUpdater.exe" -u
        )
)
CALL:LOG_TIME "Remove service files"
echo. 
del /S /Q "C:\Program Files\DELTACAST\VideoMaster\FWUpdater"
del /Q "%APPDATA%\Microsoft\Windows\Start Menu\Programs\Startup\FWUpdaterViewer.bat" > NUL 2>&1
rmdir /S /Q "C:\Program Files\DELTACAST\VideoMaster\FWUpdater"
CALL:MYSLEEP
exit /b

::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::::::::::::::::::::::::::::Check folder integrity::::::::::::::::::::::::::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

:CHECK_FOLDER_INTEGRITY
if not exist .\Resources\Drivers (
	set SCRIPT_ERROR=1
	echo CHECK_FOLDER_INTEGRITY ERROR : Drivers folder not found.
)
if not exist .\Resources\Lib32 (
	set SCRIPT_ERROR=1
	echo CHECK_FOLDER_INTEGRITY ERROR : Lib32 folder not found.
)
if not exist .\Resources\Lib64 (
	set SCRIPT_ERROR=1
	echo CHECK_FOLDER_INTEGRITY ERROR : Lib64 folder not found.
)
if not exist .\Tools (
	set SCRIPT_ERROR=1
	echo CHECK_FOLDER_INTEGRITY ERROR : Tools folder not found.
)
if not exist .\Resources\Bin (
	set SCRIPT_ERROR=1
	echo CHECK_FOLDER_INTEGRITY ERROR : Bin folder not found.
)
exit /b

::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::::::::::::::::::::::::::Check administrator rights::::::::::::::::::::::::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

:CHECK_ADMINISTRATOR_RIGHTS
NET SESSION >nul 2>&1
if %ERRORLEVEL% neq 0 echo CHECK_ADMINISTRATOR_RIGHTS ERROR : the script should be excecuted in administrator mode.
exit /b

::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::::::::::::::::::::::::::Check dependencies::::::::::::::::::::::::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

:CHECK_DEPENDENCIES
NET SESSION >nul 2>&1

if not exist "C:\Windows\System32\VCRUNTIME140.dll" (
	set SCRIPT_ERROR=1
	echo CHECK_DEPENDENCIES ERROR : VC runtime need to be installed before running the script.
)
exit /b

::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:::::::::::::::::::::::::::Creation of log folder:::::::::::::::::::::::::::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

:CREATION_OF_LOG_FOLDER
if not exist ".\Install_Log\" mkdir .\Install_Log\
CALL:LOG_TIME "Log folder creation" >> .\Install_Log\%START_TIME%.log 2>&1
exit /b

::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::


