#pragma once

#include "Engine.h"

DECLARE_LOG_CATEGORY_EXTERN(VentuzEditorPluginLog, Log, All);

class FVentuzEditorPlugin : public IModuleInterface, public FTickableGameObject
{
	void RegisterCustomClassLayout( FName ClassName, FOnGetDetailCustomizationInstance DetailLayoutDelegate );

    TSet< FName > RegisteredClassNames;

public:

	FVentuzEditorPlugin();

	/** IModuleInterface implementation */
	virtual void StartupModule() override;
	virtual void ShutdownModule() override;

    virtual void Tick( float deltaTime ) override;

    virtual bool IsTickableWhenPaused() const override;
    virtual bool IsTickableInEditor() const override;
	virtual TStatId GetStatId() const override;
};
