using System;
using System.IO;
using UnrealBuildTool;

public class VentuzEditorPlugin : ModuleRules
{
	public VentuzEditorPlugin(ReadOnlyTargetRules Target) : base(Target)
	{
    var EngineDir = Path.GetFullPath(Target.RelativeEnginePath);

		PCHUsage = ModuleRules.PCHUsageMode.UseExplicitOrSharedPCHs;

		PublicIncludePaths.AddRange(
			new string[] {
				// ... add public include paths required here ...
			}
			);
				
		
		PrivateIncludePaths.AddRange(
			new string[] {
				// ... add other private include paths required here ...
      }
      );
			
		
		PublicDependencyModuleNames.AddRange(
			new string[]
			{
        "ApplicationCore",
        "Core",
        "Engine",
        "Slate",
        "SlateCore",
		"CoreUObject",
		"BlueprintGraph",
		"VentuzPlugin",
		"BlueprintGraph",
		"ToolMenus",
				// ... add other public dependencies that you statically link with here ...
			}
			);
			
		
		PrivateDependencyModuleNames.AddRange(
			new string[]
			{
        "Core",
				"Engine",
				"Slate",
				"SlateCore",
                "UnrealEd",
                "AssetRegistry",
				"VentuzPlugin",
				"BlueprintGraph",
        "KismetCompiler",
        "EditorStyle",
				// ... add private dependencies that you statically link with here ...	
			}
            );
		
		
		DynamicallyLoadedModuleNames.AddRange(
			new string[]
			{
				// ... add any modules that your module loads dynamically here ...
			}
			);

    /*PrivateDependencyModuleNames.AddRange(new string[] { "D3D11RHI" });
    PrivateIncludePaths.AddRange(new string[]
    {
				Path.Combine(EngineDir, "Source/Runtime/Windows/D3D11RHI/Private"),
				Path.Combine(EngineDir, "Source/Runtime/Windows/D3D11RHI/Private/Windows"),
				Path.Combine(EngineDir, "Source/Editor/BlueprintGraph/Private"),
    });*/

    }
}
