using System;
using System.IO;
using UnrealBuildTool;

public class VentuzPlugin : ModuleRules
{
	public VentuzPlugin(ReadOnlyTargetRules Target) : base(Target)
	{
    var EngineDir = Path.GetFullPath(Target.RelativeEnginePath);

		PCHUsage = ModuleRules.PCHUsageMode.UseExplicitOrSharedPCHs;

        PublicIncludePaths.AddRange(
			new string[] {
				// ... add public include paths required here ...
				Path.Combine(EngineDirectory, "Plugins", "VirtualProduction", "TextureShare", "Source", "TextureShare", "Public")
				}
			);
				
		
		PrivateIncludePaths.AddRange(
			new string[] {
				// ... add other private include paths required here ...
      }
      );
			
		
		PublicDependencyModuleNames.AddRange(
			new string[]
			{
        "ApplicationCore",
        "Core",
        "CoreUObject",
        "Engine",
        "InputCore",
        "InputDevice",
        "RenderCore",
        "RHI",
        "D3D11RHI",
        "Slate",
        "SlateCore",
		//"UnrealEd", // needed for #12411 - macro: DEBUG_FOR_TICKET_12411
				// ... add other public dependencies that you statically link with here ...
			}
            );
			
		
		PrivateDependencyModuleNames.AddRange(
			new string[]
			{
        "Core",
        "InputCore",
        "InputDevice",
        "RenderCore",
        "RHI",
        "D3D11RHI",
        "ApplicationCore",
        "CoreUObject",
				"Engine",
				"Slate",
				"SlateCore",
        "RHI",
        "RenderCore",
        "Renderer",
				"Projects",
				"TextureShare",
				// ... add private dependencies that you statically link with here ...	
			}
            );


        if ( Target.Type == TargetRules.TargetType.Editor )
        {
            PrivateDependencyModuleNames.Add("UnrealEd");
        }

        DynamicallyLoadedModuleNames.AddRange(
			new string[]
			{
				// ... add any modules that your module loads dynamically here ...
			}
			);

    PrivateDependencyModuleNames.AddRange(new string[] { "D3D11RHI" });
    PrivateIncludePaths.AddRange(new string[]
    {
				Path.Combine(EngineDir, "Source/Runtime/Windows/D3D11RHI/Private"),
				Path.Combine(EngineDir, "Source/Runtime/Windows/D3D11RHI/Private/Windows"),
				Path.Combine(EngineDir, "Source/Editor/BlueprintGraph/Private"),
    });

    }
}
