// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "Components/ActorComponent.h"
#include "VentuzActorTransformSync.generated.h"

UENUM()
enum class VentuzCommunicationDirection
{
	ToVentuz,
	FromVentuz
};

UCLASS( ClassGroup=(Ventuz), meta=(BlueprintSpawnableComponent) )
class VENTUZPLUGIN_API UVentuzActorTransformSync : public UActorComponent
{
	GENERATED_BODY()

public:	
	// Sets default values for this component's properties
	UVentuzActorTransformSync();

	/**
	 * Direction of the data transfer
	 */
	UPROPERTY( Category="Ventuz", EditAnywhere)
	VentuzCommunicationDirection syncDirection = VentuzCommunicationDirection::FromVentuz;

	/**
	 * Name of the Axis UE4 node in Ventuz to sync with
	 */
	UPROPERTY( Category = "Ventuz", EditAnywhere )
	FString ventuzAxisNodeName = "VentuzAxisNode";

	/**
	 * Only sync the transformation relative to the actor's parent
	 */
	UPROPERTY( Category = "Ventuz", EditAnywhere)
	bool relativeTransform = false;

protected:
	// Called when the game starts
	virtual void BeginPlay() override;

public:	
	// Called every frame
	virtual void TickComponent(float DeltaTime, ELevelTick TickType, FActorComponentTickFunction* ThisTickFunction) override;
		
};
