#!/usr/bin/python
# vim: tabstop=4 expandtab shiftwidth=4 softtabstop=4

from aja.controlroom.base import *
import json


class App(Base):

    def __init__(self, connection):
        Base.__init__(self, connection)

    # sets
    def setSize(self, width, height):
        cmd = "/app/set_size/%sx%s" % (width, height)
        self.issue_cmd(cmd)

    def setPosition(self, x, y):
        cmd = "/app/set_position/%s,%s" % (x, y)
        self.issue_cmd(cmd)

    def setDeviceIndex(self, index):
        cmd = "/app/set_device_index/%s" % (index)
        self.issue_cmd(cmd)

    # gets
    def size(self):
        cmd = "/app/size"
        jsonVals = json.loads(self.issue_cmd(cmd))
        return jsonVals["value"]  # {w: int, h: int}

    def position(self):
        cmd = "/app/position"
        jsonVals = json.loads(self.issue_cmd(cmd))
        return jsonVals["value"]  # {x: int, y: int}

    def deviceIndex(self):
        cmd = "/app/device_index"
        jsonVals = json.loads(self.issue_cmd(cmd))
        return jsonVals["value"]

    # other
    def quit(self):
        cmd = "/app/quit"
        self.issue_cmd(cmd)
